local t = Def.ActorFrame {};

t[#t+1] = Def.ActorFrame {
	OnCommand=function(self) self:addy(-160):decelerate(0.6):addy(160) end;
	OffCommand=function(self) self:sleep(0.15):smooth(1):addy(-160) end;
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "bg shade");
		InitCommand=function(self)
			self:x(SCREEN_LEFT):y(SCREEN_TOP):horizalign(left):vertalign(top):zoomto(SCREEN_WIDTH,64)
		end;
	};	
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "left cap");
		InitCommand=function(self)
			self:x(SCREEN_LEFT):y(SCREEN_TOP):horizalign(left):vertalign(top)
		end;
	};		
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "right cap");
		InitCommand=function(self)
			self:x(SCREEN_RIGHT):y(SCREEN_TOP):horizalign(right):vertalign(top)
		end;
	};	
	Def.Sprite {
		Texture="_gear";
		InitCommand=function(self)
			self:x(SCREEN_LEFT+18):y(SCREEN_TOP+31):horizalign(left):vertalign(middle)
		end;
		OffCommand=function(self) self:linear(0.1):diffusealpha(0) end;
	};
	LoadFont("_exo 2 32px") .. {
		Name="HeaderText";
		Text=string.upper(Screen.String("HeaderText"));
		InitCommand=function(self)
			self:x(SCREEN_LEFT+60):y(SCREEN_TOP+20):horizalign(left):vertalign(top):zoom(0.75):maxwidth(SCREEN_WIDTH*0.65)
			self:diffuse(color("#26BF99"))
		end;
		OffCommand=function(self) self:sleep(0.05):linear(0.1):diffusealpha(0) end;
		UpdateScreenHeaderMessageCommand=function(self,param)
			self:settext(param.Header);
		end;
	};
	Def.Sprite {
		Texture=THEME:GetPathG("ScreenHeader", "tile lines");
		InitCommand=function(self)
			self:customtexturerect(0,0,1*6,1):vertalign(top):zoomto(SCREEN_WIDTH,64):x(SCREEN_CENTER_X):y(SCREEN_TOP+64)
		end;
		OnCommand=function(self)
			self:texcoordvelocity(-0.4,0):diffusealpha(0.6)
		end;
	};
};
return t;